IF EXISTS (SELECT * FROM SYS.TRIGGERS WHERE NAME = 'TRG_RC_CLI_CREDIARIO_PENDENTE_SALDO')
BEGIN
	DROP TRIGGER TRG_RC_CLI_CREDIARIO_PENDENTE_SALDO
END
GO
CREATE TRIGGER [dbo].[TRG_RC_CLI_CREDIARIO_PENDENTE_SALDO] ON [dbo].[RC_CREDIARIO_PARC] 
FOR INSERT, UPDATE
AS

	 
	-- DELETANDO NO INSERT
	DELETE 
		FROM 
			RC_CLI_CREDIARIO_PENDENTE_SALDO
	FROM 
		RC_CLI_CREDIARIO_PENDENTE_SALDO INNER JOIN INSERTED i ON
		RC_CLI_CREDIARIO_PENDENTE_SALDO.CD_CLI = i.CD_CLI AND
		RC_CLI_CREDIARIO_PENDENTE_SALDO.CD_EMP = i.CD_EMP ;

	INSERT INTO 
		RC_CLI_CREDIARIO_PENDENTE_SALDO (
		CD_EMP, 
		CD_CLI, 
		DT_CAD) 
	SELECT 
		distinct CD_EMP,
		CD_CLI,
		convert(varchar,getdate(),120)
	FROM
		INSERTED

--Controle de posicao financeira
DELETE
	p
FROM
	RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_CREDIARIO_PARC p 
	INNER JOIN INSERTED i ON
	p.CD_EMP = i.CD_EMP AND
	p.CD_FILIAL = 0
WHERE
	p.DT_PROC >= I.DT_LANC_CRED;

--Caso nao tenha cadastre
INSERT INTO RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_CREDIARIO_PARC
	(CD_EMP,
	CD_FILIAL,
	DT_PROC,
	DT_CAD)
SELECT DISTINCT 
	i.CD_EMP,
	0,
	MIN(i.DT_LANC_CRED),
	GETDATE()
FROM
	INSERTED i 
	LEFT OUTER JOIN RC_DEB_POSICAO_FINANCEIRA_PROCESSAR_RC_CREDIARIO_PARC p ON
	p.CD_EMP = i.CD_EMP AND
	p.CD_FILIAL = 0 
WHERE
	 p.CD_FILIAL IS NULL
GROUP BY
	i.CD_EMP,
	i.CD_FILIAL